﻿var outgoing = {
    datatable: null,
    refreshDataTable: function () {
        outgoing.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-outgoingMailTable").a4datatable({
            ajaxAction: a4.getAction("GetOutgoingMailConfigurations", "Distributions", "Admin"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Class": "id", "Key": true },
                { "Name": "Customer", "Title": resources.Customer, "Data": "Customer", "Class": "v-name" },
                { "Name": "ClientId", "Data": "ClientId", "Visible": false },
                { "Name": "DisplayName", "Title": resources.DisplayName, "Data": "DisplayName" },
                { "Name": "ServerType", "Title": resources.ServerType, "Data": "ServerTypeEnum" },
                { "Name": "ServerAddress", "Title": resources.ServerAddress, "Data": "ServerAddress" },
                { "Name": "ServerPort", "Title": resources.ServerPort, "Data": "ServerPort" },
                { "Name": "Active", "Title": resources.Active, "Data": "Active", "Label": "ActiveLabel" },
                { "Name": "UseSSL", "Title": resources.UseSSL + "/" + resources.TLS, "Data": "UseSSLValue", "Label": "UseSSLValueLabel" },
                { "Name": "Username", "Title": resources.Username, "Data": "Username" },
                { "Name": "TenantID", "Title": resources.TenantID, "Data": "TenantID" },
                { "Name": "LastConnectionStatus", "Title": resources.LastConnectionStatus, "Data": "LastConnectionStatusDisplay" },
                { "Name": "LastConnectionDate", "Title": resources.LastConnectionDate, "Data": "LastConnectionDate" },
            ],
            defaultSorting: "Customer",
            toolBarItems: [{ "Action": "delete", "Label": resources.Delete }],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                if (action == "delete") {
                    outgoing.deleteItems(ids);
                }
            },
            contextMenuItems: [
                { "Action": "test", "Label": resources.TestConnection },
                { "Divider": true },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "edit", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        modalDialog.showWindow(a4.getAction("OutgoingMailEditor", "Distributions", "Admin",
                            { configId: row.Id, clientId: row.ClientId }), 700, 650,
                            { afterClose: function () { outgoing.refreshDataTable(); } }
                        );
                        break;

                    case "delete":
                        outgoing.deleteItems(row.Id);
                        break;

                    case "test":
                        outgoing.testItem(row.Id);
                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addOutgoing", function () {
            modalDialog.showWindow(a4.getAction("OutgoingMailEditor", "Distributions", "Admin"), 600, 650, { afterClose: function () { outgoing.refreshDataTable(); } });
        });
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteConfigurationsResources, function () {
            a4.callServerMethod(a4.getAction("DeleteOutgoing", "Distributions", "Admin"), { itemIds: items },
                function (result) {
                    outgoing.refreshDataTable();
                });
        }, 250, 400, true, { "count": itemsCount });
    },
    testItem: function (id, serverType, address, port, username, password, useSSL, region, from, to) {
        a4.callServerMethod(a4.getAction("TestOutgoingConnection", "Distributions", "Admin"), { id: id, serverType: serverType, address: address, port: port, username: username, password: password, useSSL: useSSL, region: region, from: from, to: to },
            function (result) {
                if (result.success)
                    a4.showSuccessMessage(result.message);
                else
                    a4.showErrorMessage(result.message);

                if (id > 0)
                    outgoing.refreshDataTable();
            });
    }
}

$(document).ready(function () {
    if ($(".v-outgoingMailTable").length > 0) {
        outgoing.initializeDataTable();
        outgoing.bindEvents();
    }
});